<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_183.xsd"
				xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
	<xsl:template match="ns1:SENT_183">
		<!-- TODO: Auto-generated template -->
		<html>
			<head>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .sent-xslt {
          border-collapse: initial;
          }

          .sent-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#c5c2c2;
          font-weight: normal;
          font-size: 12px;
          margin-bottom: 0;
          border-bottom: 1px solid #c8c9ca;
          }

          .sent-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .sent-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .sent-xslt .grupName {
          font-size: 12px;
          margin: 0 !important;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .element-2 {
          font-size: 14px;
          font-weight: normal;
          color: #008540;
          }

          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .sent-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .grupInfoSent {
          min-height: 40px;
          }

          .sent-xslt .grupInfoSent p {
          margin: -2px 0 1px 10px;
          font-size: 16px;
          font-weight: bold;
          }

          .sent-xslt .oilstatus {
          margin: 0 5px 0 -5px;
          margin: 2px 0 1px 10px;
          font-size: 14px;
          padding-bottom: 12px;
          color: red;
          }

          .sent-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .sent-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .sent-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          .sent-xslt .table {
          display: table;
          width: 99%;
          margin: 4px 0 15px 7px;
          border-spacing: 0 0;
          border-top: 1px solid #999999;
          border-left: 1px solid #999999;
          }

          .sent-xslt .table-header {
          font-size: 10px;
          font-weight: bold;
          padding: 5px;
          background-color: #ececec;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element {
          font-size: 12px;
          font-weight: normal;
          padding: 2px 5px;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element2 {
          font-size: 12px;
          font-weight: normal;
          padding: 0;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element3 {
          font-size: 12px;
          font-weight: bold;
          border: 1px #999999;
          border-top-style: solid;
          margin: 0;
          }

          .sent-xslt .table-element p {
          margin-left: 0;
          }

          .sent-xslt .table-element3 p {
          margin-left: 0;
          padding: 0px 5px;
          }

        </style>
			</head>
      <body>
        <div class="sent-xslt">
          <section class="sent-xslt s1">
            <h1>SENT183 - ZGŁOSZENIE AKTUALIZACYJNE UMOWY</h1>
            <div class="sent-xslt t1">
              <div class="sent-xslt grupInfoSent">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1">NUMER UMOWY: </span>
                    <br/>
                    <xsl:value-of select="ns1:AgreementNumber"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">DANE IDENTYFIKACYJNE PODMIOTU SPRZEDAJĄCEGO</p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <xsl:if test="ns1:InformationAboutSender/tp:IdSisc !=''">
                    <p>
                      <span class="sent-xslt element-1">Identyfikator idSISC: </span>
                      <xsl:value-of select="ns1:InformationAboutSender/tp:IdSisc"/>
                    </p>
                  </xsl:if>
                  <p>
                    <span class="sent-xslt element-1">Nazwa pełna: </span>
                    <xsl:value-of select="ns1:InformationAboutSender/tp:TraderOrPersonName"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1">Typ identyfikatora: </span>
                    <xsl:value-of select="ns1:InformationAboutSender/tp:TraderIdentityType"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1">Numer identyfikatora: </span>
                    <xsl:value-of select="ns1:InformationAboutSender/tp:TraderIdentityNumber"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">DANE IDENTYFIKACYJNE PODMIOTU ODBIERAJĄCEGO</p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <xsl:if test="ns1:InformationAboutRecipient/tp:IdSisc !=''">
                    <p>
                      <span class="sent-xslt element-1">Identyfikator idSISC: </span>
                      <xsl:value-of select="ns1:InformationAboutRecipient/tp:IdSisc"/>
                    </p>
                  </xsl:if>
                  <p>
                    <span class="sent-xslt element-1">Nazwa pełna: </span>
                    <xsl:value-of select="ns1:InformationAboutRecipient/tp:TraderOrPersonName"/>
                  </p>
                </div>
                <div class="sent-xslt info1">

                  <p>
                    <span class="sent-xslt element-1">Typ identyfikatora: </span>
                    <xsl:value-of select="ns1:InformationAboutRecipient/tp:TraderIdentityType"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1">Numer identyfikatora: </span>
                    <xsl:value-of select="ns1:InformationAboutRecipient/tp:TraderIdentityNumber"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">DANE DOTYCZĄCE UMOWY</p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1">obowiązuje od: </span>
                    <xsl:choose>
                      <xsl:when test="string-length(ns1:InformationAboutAgreement/tp:DateAgreementFrom) > 10">
                        <xsl:value-of select="substring-before(ns1:InformationAboutAgreement/tp:DateAgreementFrom, '+')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="ns1:InformationAboutAgreement/tp:DateAgreementFrom"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <span class="sent-xslt element-1"> do: </span>
                    <xsl:choose>
                      <xsl:when test="string-length(ns1:InformationAboutAgreement/tp:DateAgreementTo) > 10">
                        <xsl:value-of select="substring-before(ns1:InformationAboutAgreement/tp:DateAgreementTo, '+')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="ns1:InformationAboutAgreement/tp:DateAgreementTo"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <xsl:choose>
                      <xsl:when test="ns1:InformationAboutAgreement/tp:UnitOfMeasure ='kg'"><span class="sent-xslt element-1">Ilość oleju opałowego cięzkiego: </span></xsl:when>
                      <xsl:when test="ns1:InformationAboutAgreement/tp:UnitOfMeasure ='l'"><span class="sent-xslt element-1">Ilość oleju opałowego lekkiego: </span></xsl:when>
                      <xsl:otherwise><span class="sent-xslt element-1">Ilość oleju opałowego: </span> </xsl:otherwise>
                    </xsl:choose>
                    <xsl:value-of select="ns1:InformationAboutAgreement/tp:AgreementAmountOfGoods"/>&#160;<xsl:value-of select="ns1:InformationAboutAgreement/tp:UnitOfMeasure"/>
                  </p>
                </div>
              </div>
            </div>
            <xsl:if test="((ns1:Comments != '') or (ns1:DocumentId != ''))">
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName">INFORMACJE DODATKOWE</p>
                <div class="sent-xslt t1">
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info">
                      <xsl:if test="ns1:Comments != ''">
                        <p>
                          <span class="sent-xslt element-1">Uwagi: </span>
                          <xsl:value-of select="ns1:Comments"/>
                        </p>
                      </xsl:if>
                    </div>
                  </div>
                </div>
                <xsl:if test="ns1:DocumentId != ''">
                  <div class="sent-xslt t1">
                    <div class="sent-xslt grupInfo">
                      <div class="sent-xslt info">
                        <p>
                          <span class="sent-xslt element-1">Numer własny zgłoszenia: </span>
                          <xsl:value-of select="ns1:DocumentId"/>
                        </p>
                      </div>
                    </div>
                  </div>
                </xsl:if>
              </div>
            </xsl:if>
            <xsl:if test="ns1:ResponseAddress != ''">
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName">KANAŁY KOMUNIKACJI ZWROTNEJ</p>
                <div class="sent-xslt grupInfo">
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-2">Adresy e-mail</span>
                    </p>
                    <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress1 != ''">
                      <p>
                        <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress1"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress2 != ''">
                      <p>
                        <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress2"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress3 != ''">
                      <p>
                        <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress3"/>
                      </p>
                    </xsl:if>
                  </div>
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-2">Kanał Web service</span>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Adres Web service zapisany w usłudze e-Klient: </span>
                      <span>
                        <xsl:choose>
                          <xsl:when test="ns1:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'true'">
                            <span>Tak</span>
                          </xsl:when>
                          <xsl:when test="ns1:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'false'">
                            <span>Nie</span>
                          </xsl:when>
                        </xsl:choose>
                      </span>
                    </p>
                    <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress != ''">
                      <p>
                        <span class="sent-xslt element-1">Adres URL: </span>
                        <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:Username != ''">
                      <p>
                        <span class="sent-xslt element-1">Nazwa użytkownika: </span>
                        <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:Username"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:UserPassword != ''">
                      <p>
                        <span class="sent-xslt element-1">Hasło: </span>
                        <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:UserPassword"/>
                      </p>
                    </xsl:if>
                    <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey != ''">
                      <p>
                        <span class="sent-xslt element-1">Odcisk palca certyfikatu: </span>
                        <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey"/>
                      </p>
                    </xsl:if>
                  </div>
                </div>
              </div>
            </xsl:if>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">OŚWIADCZENIA</p>
              <div class="sent-xslt grupInfo">
                <p>
                  <xsl:choose>
                    <xsl:when test="ns1:Statements/tp:Statement1 = 'true'">
                      <input type="checkbox" onclick="return false;" checked=""/>
                      <span class="sent-xslt element-1" data-phrase-id="sentStatements1"></span>
                    </xsl:when>
                    <xsl:when test="ns1:Statements/tp:Statement1 = 'false'">
                      <input type="checkbox" onclick="return false;"/>
                      <span class="sent-xslt element-1" data-phrase-id="sentStatements1"></span>
                    </xsl:when>
                  </xsl:choose>
                  <span class="sent-xslt element-1">Posiadam upoważnienie do działania w imieniu podmiotu zobowiązanego do wypełnienia i przesłania zgłoszenia</span>
                </p>
                <p style="padding: 5px">
                  <span class="sent-xslt element-1">Imię i nazwisko: </span>
                  <xsl:value-of select="ns1:Statements/tp:FirstName"/>&#160;<xsl:value-of select="ns1:Statements/tp:LastName"/>
                </p>
              </div>
            </div>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
